#include "junkyard.h"

Junkyard::Junkyard(Object *parent, int x, int y) : StaticObject(parent, new RepulseField("junkyard.prf", x, y), new Texture("junkyard.tga")) {
	wall = new StaticObject(this, new RepulseField("wall.prf", x + 414, y + 247), new Texture("wall.tga"));
}

void Junkyard::stepFunc() {
	StaticObject::stepFunc();

	if(numin > 10 && numin > numout * 5 && wall->rf->x > rf->x + 294) wall->rf->x--;
	else if(wall->rf->x < rf->x + 414) wall->rf->x++;

	numin = 0;
	numout = 0;
	numtracs = 0;
}

void Junkyard::atomFunc(Atom *a) {
	if(a->level != 3 && a->level != 9) {
		StaticObject::atomFunc(a);
		return;
	}

	const int cx = 354;
	int cy;
	if(a->numlinks > 1)
		cy = 275;
	else
		cy = 258;

	const float d = 350.0f;
	const float dd = d * d;
	const float cd = 100.0f;
	const float cdcd = cd * cd;

	int ax = a->x - rf->x;
	int ay = a->y - rf->y;
	int dx = ax - cx;
	int dy = ay - cy;

	if(a->numlinks < 2 && dx > -100 && dx < 100 && dy > -10 && dy < 3) {
		a->destroy();
		return;
	}

	dx *= 2.0f;
	if(dy < 0) dy *= 3.0f;

	float dist = dx * dx + dy * dy;
	if(dist < dd) {
		if(numtracs < 200) {
			tracs[numtracs][0] = a->x;
			tracs[numtracs][1] = a->y;
			numtracs++;
		}
		float mult;
		mult = float(d / sqrt(dist));
		mult = 1.0f - mult;

		float forcex = 0.0003f * (dx * mult - dx);
		float forcey = 0.0003f * (dy * mult - dy);
		if(a->x > wall->rf->x + 5 && ay < 400) {
			forcey = 0.15f;
			numout++;
		}
		else if(dy > 80)
			numout++;
		else
			numin++;

		if(forcex * (a->x - a->ox) < 0)
			a->fx += 3.0f * forcex;
		else
			a->fx += forcex;

		if(forcey * (a->y - a->oy) < 0)
			a->fy += 3.0f * forcey;
		else
			a->fy += forcey;
	}

	StaticObject::atomFunc(a);
}

void Junkyard::draw() {
	StaticObject::draw();
	
	int i;

	glColor4f(1.0f, 1.0f, 0.0f, 0.5f);
	glLineWidth(5.0f);

	glBegin(GL_LINES);
	for(i = 0; i < numtracs; i++) {
		glVertex3d(rf->x + 282, rf->y + 354, 0);
		glVertex3d(tracs[i][0], tracs[i][1], 0);
	}
	glEnd();
}
